@echo off
:: 64th service BSOD Fixer - Clean & Professional Edition
title 64th service BSOD Fixer
color  0A

:: Admin Rights Check
>nul 2>&1 "%SYSTEMROOT%\system32\cacls.exe" "%SYSTEMROOT%\system32\config\system"
if '%errorlevel%' NEQ '0' (
    echo [!] Requesting administrative privileges...
    goto :UACPrompt
) else (
    goto :Admin
)

:UACPrompt
    echo Set UAC = CreateObject^("Shell.Application"^) > "%temp%\getadmin.vbs"
    echo UAC.ShellExecute "%~s0", "", "", "runas", 1 >> "%temp%\getadmin.vbs"
    "%temp%\getadmin.vbs"
    exit /B

:Admin
    if exist "%temp%\getadmin.vbs" del "%temp%\getadmin.vbs"

cls
echo ====================================================
echo            64th Service BSOD Fixer - STARTING
echo ====================================================
echo.

:: Fully Disable Driver Blocklist
echo [*] Disabling Driver Blocklist...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\CI\Config" /v "VulnerableDriverBlocklistEnable" /t REG_DWORD /d 0 /f
reg delete "HKLM\SYSTEM\CurrentControlSet\Control\CI\Policy" /v "RevokedDrivers" /f
timeout /t 2 /nobreak >nul

echo.

:: Enable Test Signing Mode
echo [*] Enabling Test Signing Mode...
bcdedit /set testsigning on
timeout /t 2 /nobreak >nul

echo.

:: Disable Memory Integrity (HVCI)
echo [*] Disabling Memory Integrity (HVCI)...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\DeviceGuard\Scenarios\HypervisorEnforcedCodeIntegrity" /v "Enabled" /t REG_DWORD /d 0 /f
timeout /t 2 /nobreak >nul

echo.

:: Disable Automatic Driver Updates
echo [*] Disabling Automatic Driver Updates...
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\DriverSearching" /v "SearchOrderConfig" /t REG_DWORD /d 0 /f
reg add "HKLM\SOFTWARE\Microsoft\WindowsUpdate\UX\Settings" /v "ExcludeWUDriversInQualityUpdate" /t REG_DWORD /d 1 /f
timeout /t 2 /nobreak >nul

echo.

:: Disable Core Isolation
echo [*] Disabling Core Isolation...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\DeviceGuard" /v "EnableVirtualizationBasedSecurity" /t REG_DWORD /d 0 /f
reg add "HKLM\SYSTEM\CurrentControlSet\Control\DeviceGuard" /v "RequirePlatformSecurityFeatures" /t REG_DWORD /d 0 /f
timeout /t 2 /nobreak >nul

echo.

:: Disable Tamper Protection
echo [*] Disabling Tamper Protection...
reg add "HKLM\SOFTWARE\Microsoft\Windows Defender\Features" /v "TamperProtection" /t REG_DWORD /d 0 /f
timeout /t 2 /nobreak >nul

echo.

:: Disable Fast Startup
echo [*] Disabling Fast Startup...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Power" /v "HiberbootEnabled" /t REG_DWORD /d 0 /f
timeout /t 2 /nobreak >nul

echo.

:: Apply Additional Tweaks
echo [*] Applying additional tweaks...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v FeatureSettingsOverride /t REG_DWORD /d 3 /f
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v FeatureSettingsOverrideMask /t REG_DWORD /d 3 /f
reg add "HKLM\SYSTEM\CurrentControlSet\Control\CI\Config" /v VulnerableDriverBlocklistEnable /t REG_DWORD /d 0 /f
bcdedit /set hypervisorlaunchtype off
timeout /t 2 /nobreak >nul

:: Finish
cls
color 0A
echo ====================================================
echo         [!] All changes completed!
echo         [!] System will restart shortly...
echo ====================================================
timeout /t 10 /nobreak
shutdown /r /t 0
exit
